<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Commercial_Vista_Investments
 */

?>
<?php
$footer_logo = get_field('footer_logo', 'options');
$footer_description = get_field('footer_description', 'options');
$phone_icon = get_field('phone_icon', 'options');
$phone_number = get_field('phone_number', 'options');
$f_email_icon = get_field('f_email_icon', 'options');
$email_address = get_field('email_address', 'options');
$quick_links_title = get_field('quick_links_title', 'options');
$stay_in_touch_title = get_field('stay_in_touch_title', 'options');
$join_the_mailing_list_title = get_field('join_the_mailing_list_title', 'options');
$select_mail_form = get_field('select_mail_form', 'options');
$copyright_text = get_field('copyright_text', 'options');
$select_policy_pages = get_field('select_policy_pages', 'options');
$social_media_details = get_field('social_media_details', 'options');

$footer_menu = wp_get_nav_menu_items('Footer Menu');
if ($footer_menu !== false) {
	$footer_menu_count = count($footer_menu);
} else {
	$footer_menu_count = 0;
}
?>
<?php if ($footer_logo || $footer_description || $phone_number || $email_address || ($footer_menu_count > 0) || $select_mail_form || $copyright_text || $select_policy_pages || !empty($social_media_details)): ?>
	<footer>
		<div class="container">
			<?php if ($footer_logo || $footer_description || $phone_number || $email_address || ($footer_menu_count > 0) || $select_mail_form): ?>
				<div class="footer-top">
					<div class="row">
						<?php if ($footer_logo || $footer_description || $phone_number || $email_address): ?>
							<div class="col-md-4 col-sm-12">
								<div class="about-footer">
									<?php if ($footer_logo): ?>
										<figure>
											<img src="<?php echo $footer_logo['url']; ?>" alt="<?php echo $footer_logo['alt']; ?>">
										</figure>
									<?php endif; ?>

									<?php echo apply_filters('the_content', $footer_description); ?>

									<?php if ($phone_number || $email_address): ?>
										<ul>
											<?php if ($email_address): ?>
												<li>
													<a href="mailto:<?php echo $email_address; ?>">
														<?php if ($f_email_icon): ?>
															<figure>
																<img src="<?php echo esc_url($f_email_icon['url']); ?>"
																	alt="<?php echo esc_attr($f_email_icon['alt']); ?>">
															</figure>
														<?php endif; ?>
														<?php echo $email_address; ?>
													</a>
												</li>
											<?php endif; ?>
											<?php if ($phone_number): ?>
												<li>
													<a href="tel:<?php echo preg_replace("/[^0-9]+/", "", $phone_number); ?>">
														<?php if ($phone_icon): ?>
															<figure>
																<img src="<?php echo esc_url($phone_icon['url']); ?>"
																	alt="<?php echo esc_attr($phone_icon['alt']); ?>">
															</figure>
														<?php endif; ?>
														<?php echo $phone_number; ?>
													</a>
												</li>
											<?php endif; ?>
										</ul>
									<?php endif; ?>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($footer_menu_count > 0): ?>
							<div class="col-md-4 col-sm-12">
								<div class="quicklinks-rw">
									<?php echo $quick_links_title ? '<h3>' . $quick_links_title . '</h3>' : ''; ?>

									<div class="quicklinks-rw-col">
										<div class="quicklinksbx">
											<?php
											wp_nav_menu(array(
												'depth' => 3, // 1 = no dropdowns, 2 = with dropdowns.
												'container' => '',
												'container_class' => '',
												'container_id' => '',
												'menu_class' => '',
												'menu' => 'Footer Menu',
												//'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
												// 'walker' => new WP_Bootstrap_Navwalker(),
											));
											?>
										</div>

										<!-- <div class="quicklinksbx">
											<ul>
												<li><a href="#">Why Commercialvista</a></li>
												<li><a href="#">Our Process</a></li>
												<li><a href="#">Investment Model</a></li>
											</ul>
										</div> -->
									</div>
								</div>
							</div>
						<?php endif; ?>
						<?php if ($select_mail_form): ?>
							<div class="col-md-4 col-sm-12">
								<div class="subscribe-box">
									<?php echo $stay_in_touch_title ? '<h3>' . $stay_in_touch_title . '</h3>' : ''; ?>

									<div class="join-bx">
										<?php echo $join_the_mailing_list_title ? '<h4>' . $join_the_mailing_list_title . '</h4>' : ''; ?>
										<?php echo do_shortcode('[contact-form-7 id="' . $select_mail_form->ID . '" title="' . $select_mail_form->post_title . '"]'); ?>
									</div>
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>
			<?php if ($copyright_text || $select_policy_pages || !empty($social_media_details)): ?>
				<div class="copyright">
					<div class="row">
						<?php if ($copyright_text || $select_policy_pages): ?>
							<div class="col-md-7 col-sm-12">
								<p>
									<?php if ($copyright_text): ?>
										<?php echo do_shortcode($copyright_text); ?>
									<?php endif; ?>
									<?php if ($select_policy_pages): ?>
										<a href="<?php echo get_the_permalink($select_policy_pages->ID); ?>">
											<?php echo $select_policy_pages->post_title; ?>
										</a>
									<?php endif; ?>
								</p>
							</div>
						<?php endif; ?>
						<?php if (!empty($social_media_details)): ?>
							<div class="col-md-5 col-sm-12">
								<div class="footer-socialbx">
									<?php foreach ($social_media_details as $media): 
										$social_media_white_icon = $media['social_media_white_icon'];
										$social_media_link = $media['social_media_link'];
									?>
										<?php if ($social_media_white_icon && $social_media_link): ?>
											<a href="<?php echo $social_media_link['url']; ?>" target="<?php echo $social_media_link['target']; ?>" rel="noopener noreferrer">
												<figure>
													<img src="<?php echo $social_media_white_icon['url']; ?>" alt="<?php echo $social_media_white_icon['alt']; ?>">
												</figure>
											</a>
										<?php endif; ?>
									<?php endforeach; ?>									
								</div>
							</div>
						<?php endif; ?>
					</div>
				</div>
			<?php endif; ?>
		</div>
	</footer>
<?php endif; ?>
</main>

<?php wp_footer(); ?>

</body>

</html>