<?php
/**
 * Commercial Vista Investments functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Commercial_Vista_Investments
 */

require_once(get_template_directory() . '/admin/class-wp-bootstrap-navwalker.php');

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function commercial_vista_investments_setup() {
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on Commercial Vista Investments, use a find and replace
		* to change 'commercial-vista-investments' to the name of your theme in all the template files.
		*/
	load_theme_textdomain( 'commercial-vista-investments', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support( 'title-tag' );

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'commercial-vista-investments' ),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'commercial_vista_investments_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action( 'after_setup_theme', 'commercial_vista_investments_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function commercial_vista_investments_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'commercial_vista_investments_content_width', 640 );
}
add_action( 'after_setup_theme', 'commercial_vista_investments_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function commercial_vista_investments_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'commercial-vista-investments' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'commercial-vista-investments' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'commercial_vista_investments_widgets_init' );

/**
 * Enqueue scripts and styles.
 */

define('SITE_URL', home_url());
define('THEME_PATH', get_template_directory() . '/');
define('THEME_URI', get_template_directory_uri() . '/');
define('THEME_CSS', THEME_URI . 'assets/css/');
define('THEME_JS', THEME_URI . 'assets/js/');
define('THEME_IMG', THEME_URI . 'assets/images/');
define('THEME_FONTS', THEME_URI . 'assets/fonts/');
define('DEFAULT_IMG', THEME_IMG . 'default.png');
define('themenamespace', wp_get_theme());
define('SITE_NAME', get_bloginfo('name'));
define('SITE_TAGLINE', get_bloginfo('description'));

function commercial_vista_investments_scripts() {
	wp_enqueue_style('all.css', 'https://pro.fontawesome.com/releases/v5.10.0/css/all.css');
	wp_enqueue_style('swiper', 'https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css');
	wp_enqueue_style('aos', THEME_CSS . 'aos.css');
	wp_enqueue_style('bootstrap', THEME_CSS . 'bootstrap.min.css');
	wp_enqueue_style('style', THEME_CSS . 'style.css');
	wp_enqueue_style('responsive', THEME_CSS . 'responsive.css');


	wp_enqueue_script('jquery');
	wp_enqueue_script('bootstrap', THEME_JS . 'bootstrap.bundle.min.js', null, true);
	wp_enqueue_script('swiper', 'https://cdnjs.cloudflare.com/ajax/libs/Swiper/8.4.5/swiper-bundle.min.js', null, true);
	wp_enqueue_script('aos', THEME_JS . 'aos.js', null, true);
	wp_enqueue_script('custom-script', THEME_JS . 'custom.js', null, true);
}
add_action( 'wp_enqueue_scripts', 'commercial_vista_investments_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

// years dynamic
function currentYear($atts)
{
	return date('Y');
}
add_shortcode('year', 'currentYear');
 
// Allow SVG
function allow_svg($mimes)
{
	$mimes['svg'] = 'image/svg+xml';
	$mimes['svgz'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'allow_svg');
function fix_mime_type_svg($data = null, $file = null, $filename = null, $mimes = null)
{
	$ext = isset($data['ext']) ? $data['ext'] : '';
	if (strlen($ext) < 1) {
		$exploded = explode('.', $filename);
		$ext = strtolower(end($exploded));
	}
	if ($ext === 'svg') {
		$data['type'] = 'image/svg+xml';
		$data['ext'] = 'svg';
	} elseif ($ext === 'svgz') {
		$data['type'] = 'image/svg+xml';
		$data['ext'] = 'svgz';
	}
	return $data;
}
add_filter('wp_check_filetype_and_ext', 'fix_mime_type_svg', 75, 4);
function fix_svg()
{
	echo '<style type="text/css">
        .attachment-266x266, .thumbnail img {
             width: 100% !important;
             height: auto !important;
        }
</style>';
}
add_action('admin_head', 'fix_svg');
 
 
//  allow span in acf Field 
function override_mce_options($initArray)
{
	$opts = '*[*]';
	$initArray['valid_elements'] = $opts;
	$initArray['extended_valid_elements'] = $opts;
	return $initArray;
}
add_filter('tiny_mce_before_init', 'override_mce_options');
 
 
//  CONTACT FORM 7 REMOVE P TAGE
add_filter('wpcf7_autop_or_not', '__return_false');
// Function for remove block editor widget style in apperance/widgets
function disable_block_widgets() {
    remove_theme_support('widgets-block-editor');
}
add_action('after_setup_theme', 'disable_block_widgets');