<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Commercial_Vista_Investments
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>


	<main class="main-wrpper">

		<!-- Header -->
		<?php
		$header_logo = get_field( 'header_logo', 'options' );
		$email_icon = get_field( 'email_icon', 'options' );
		$email_address = get_field( 'email_address', 'options' );
		$follow_us_title = get_field( 'follow_us_title', 'options' );
		$social_media_details = get_field( 'social_media_details', 'options' );

		$header_menu = wp_get_nav_menu_items('Header Menu');
		if ($header_menu !== false) {
			$header_menu_count = count($header_menu);
		} else {
			$header_menu_count = 0;
		}


		?>
		<?php if($header_logo || $email_address || !empty($social_media_details) || ($header_menu_count > 0)): ?>
			<header>
				<div class="container">
					<nav class="navbar navbar-expand-lg navbar-light">
						<?php if ($header_logo): ?>
							<a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
								<img src="<?php echo esc_url($header_logo['url']); ?>" alt="<?php echo esc_attr($header_logo['alt']); ?>" />
							</a>
						<?php endif; ?>
						<?php if($email_address || !empty($social_media_details) || ($header_menu_count > 0)) : ?>
							<button class="navbar-toggler" type="button" data-bs-toggle="collapse"
								data-bs-target="#NavbarToggle" aria-controls="NavbarToggle" aria-expanded="false"
								aria-label="Toggle navigation">
								<span class="navbar-toggler-icon"></span>
							</button>
							<div class="collapse navbar-collapse" id="NavbarToggle">
								<div class="nav-row">
									<?php if($email_address || !empty($social_media_details)) : ?>
										<div class="topbar">
											<?php if($email_address): ?>
												<div class="top-mail">
													<a href="mailto:<?php echo $email_address; ?>">
														<p><?php echo $email_icon; ?> <?php echo $email_address; ?></p>
													</a>
												</div>
											<?php endif; ?>
											<?php if(!empty($social_media_details)): ?>
												<div class="top-social-bx">
													<?php echo $follow_us_title ? '<h4>'.$follow_us_title.'</h4>' : ''; ?>
													<?php foreach($social_media_details as $media) : 
														$social_media_black_icon = $media['social_media_black_icon'];
														$social_media_link = $media['social_media_link'];
													?>
														<?php if($social_media_black_icon && $social_media_link) : ?>
															<a href="<?php echo $social_media_link['url']; ?>" target="<?php echo $social_media_link['target']; ?>" rel="noopener noreferrer">
																<figure>
																	<img src="<?php echo $social_media_black_icon['url']; ?>" alt="<?php echo $social_media_black_icon['alt']; ?>">
																</figure>
															</a>
														<?php endif; ?>
													<?php endforeach; ?>
												</div>
											<?php endif; ?>
										</div>
									<?php endif; ?>
									<?php if (($header_menu_count > 0)): ?>
										<div class="navbar-nav">
											<?php
											wp_nav_menu(array(
												'depth' => 3, // 1 = no dropdowns, 2 = with dropdowns.
												'container' => '',
												'container_class' => '',
												'container_id' => '',
												'menu_class' => '',
												'menu' => 'Header Menu',
												//'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
												'walker' => new WP_Bootstrap_Navwalker(),
											));
											?>
										</div>
									<?php endif; ?>
								</div>
							</div>
						<?php endif; ?>
					</nav>
				</div>
			</header>
		<?php endif; ?>
		<!-- End Header -->