<?php
// Template Name: About Us Page
get_header();
while (have_posts()):
    the_post();
    ?>

    <!-- Banner Section -->
    <?php
    $b_background_image = get_field('b_background_image');
    $b_main_title = get_field('b_main_title');
    ?>
    <?php if ($b_background_image || $b_main_title): ?>
        <section class="inner-banner">
            <?php if ($b_background_image): ?>
                <figure>
                    <img src="<?php echo $b_background_image['url']; ?>" alt="<?php echo $b_background_image['alt']; ?>">
                </figure>
            <?php endif; ?>
            <?php if ($b_main_title): ?>
                <div class="banner-center">
                    <div class="container">
                        <div class="banner-data" data-aos="fade-up" data-aos-duration="1000">
                            <?php echo $b_main_title; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </section>
    <?php endif; ?>
    <!-- End Banner Section -->

    <!-- About Us Section -->
    <?php
    $eis_image = get_field('eis_image');
    $eis_main_title = get_field('eis_main_title');
    $eis_description = get_field('eis_description');
    ?>
    <?php if ($eis_image || $eis_main_title || $eis_description): ?>
        <section class="about-pg-wrp">
            <div class="container">
                <div class="row">
                    <?php if ($eis_image): ?>
                        <div class="col-md-4 col-sm-12">
                            <div class="about-pg-img" data-aos="fade-right" data-aos-duration="1000">
                                <figure>
                                    <img src="<?php echo $eis_image['url']; ?>" alt="<?php echo $eis_image['alt']; ?>">
                                </figure>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($eis_main_title || $eis_description): ?>
                        <div class="col-md-8 col-sm-12">
                            <div class="about-pg-data" data-aos="fade-left" data-aos-duration="1000">
                                <?php if ($eis_main_title): ?>
                                    <div class="titlebar">
                                        <?php echo $eis_main_title; ?>
                                    </div>
                                <?php endif; ?>

                                <?php echo $eis_description; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- End About Us Section -->

    <!-- Team Section -->
    <?php
    $oes_main_title = get_field('oes_main_title');
    $oes_description = get_field('oes_description');

    $args = array(
        'post_type' => 'expert',
        'post_status' => 'publish',
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC'
    );

    $experts = new WP_Query($args);
    ?>
    <?php if ($experts->have_posts()): ?>
        <section class="professional-wrp about-professional-wrp">
            <div class="container">
                <?php if ($oes_main_title || $oes_description): ?>
                    <div class="professional-head" data-aos="fade-up" data-aos-duration="1000">
                        <div class="row">
                            <?php if ($oes_main_title): ?>
                                <div class="col-md-7 col-sm-12">
                                    <div class="titlebar">
                                        <?php echo $oes_main_title; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if ($oes_description): ?>
                                <div class="col-md-5 col-sm-12">
                                    <?php echo $oes_description; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php while ($experts->have_posts()):
                    $experts->the_post(); ?>
                    <?php
                    $title = get_the_title();
                    $content = get_the_content();
                    $img = get_the_post_thumbnail_url();
                    ?>
                    <?php if ($title || $content || $img): ?>
                        <div class="professional-row" data-aos="fade-up" data-aos-duration="1500">
                            <div class="row">
                                <?php if ($title || $content): ?>
                                    <div class="col-md-7 col-sm-12">
                                        <div class="professional-data">
                                            <?php if ($title): ?>
                                                <h3><?php echo $title; ?></h3>
                                            <?php endif; ?>
                                            <?php if ($content): ?>
                                                <?php echo apply_filters('the_content', $content); ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ($img): ?>
                                    <div class="col-md-5 col-sm-12">
                                        <div class="professional-img">
                                            <figure>
                                                <img src="<?php echo $img; ?>" alt="<?php $title; ?>">
                                            </figure>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </section>
    <?php endif; ?>
    <!-- End Team Section -->

    <!-- Map Section -->
    <?php get_template_part('template-parts/content', 'map'); ?>
                                    

    <?php
endwhile;
get_footer();
?>