<?php
// Template Name: Home Page
get_header();
while (have_posts()):
    the_post();
?>

    <!-- Hero Banner -->
    <?php
    $b_background_image = get_field('b_background_image');
    $b_main_title = get_field('b_main_title');
    $b_short_description = get_field('b_short_description');
    $b_get_kit_button = get_field('b_get_kit_button');
    ?>
    <?php if ($b_background_image || $b_main_title || $b_short_description): ?>
        <section class="hero-banner">
            <?php if ($b_background_image): ?>
                <div class="hero-banner-back">
                    <figure>
                        <img src="<?php echo $b_background_image['url']; ?>" alt="<?php echo $b_background_image['alt']; ?>">
                    </figure>
                </div>
            <?php endif; ?>

            <?php if ($b_main_title || $b_short_description || $b_get_kit_button): ?>
                <div class="banner-center">
                    <div class="container">
                        <div class="banner-data" data-aos="fade-up" data-aos-duration="1000">
                            <?php echo $b_main_title; ?>
                            <?php echo $b_short_description; ?>
                            <?php if ($b_get_kit_button): ?>
                                <a href="<?php echo $b_get_kit_button['url']; ?>" target="<?php echo $b_get_kit_button['target']; ?>"
                                    class="btn-main">
                                    <?php echo $b_get_kit_button['title']; ?>
                                    <i class="fal fa-arrow-right"></i>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </section>
    <?php endif; ?>
    <!-- End Hero Banner -->

    <!-- About Section -->
    <?php
    $bvs_image = get_field('bvs_image');
    $bvs_main_title = get_field('bvs_main_title');
    $bvs_description = get_field('bvs_description');
    $bvs_learn_more_button = get_field('bvs_learn_more_button');
    ?>
    <?php if ($bvs_image || $b_main_title || $bvs_description): ?>
        <section class="about-wrp">
            <div class="container">
                <div class="row">
                    <?php if ($bvs_image): ?>
                        <div class="col-md-5 col-sm-12">
                            <div class="about-img" data-aos="fade-right" data-aos-duration="1000">
                                <figure>
                                    <img src="<?php echo $bvs_image['url']; ?>" alt="<?php echo $bvs_image['alt']; ?>">
                                </figure>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if ($bvs_main_title || $bvs_description || $bvs_learn_more_button): ?>
                        <div class="col-md-7 col-sm-12">
                            <div class="about-data" data-aos="fade-left" data-aos-duration="1000">
                                <?php if ($bvs_main_title): ?>
                                    <div class="titlebar">
                                        <?php echo $bvs_main_title; ?>
                                    </div>
                                <?php endif; ?>

                                <?php echo $bvs_description; ?>
                                <?php if ($bvs_learn_more_button): ?>
                                    <a href="<?php echo $bvs_learn_more_button['url']; ?>"
                                        target="<?php echo $bvs_learn_more_button['target']; ?>" class="btn-main">
                                        <?php echo $bvs_learn_more_button['title']; ?>
                                        <i class="fal fa-arrow-right"></i>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- End About Section -->

    <!-- Multifamily Section -->
    <?php
    $wms_main_title = get_field('wms_main_title');
    $wms_short_description = get_field('wms_short_description');
    $wms_why_us_details = get_field('wms_why_us_details');
    ?>
    <?php if ($wms_main_title || $wms_short_description || !empty($wms_why_us_details)): ?>
        <section class="multifamily-wrp">
            <div class="container">
                <?php if ($wms_main_title || $wms_short_description) : ?>
                    <div class="titlebar" data-aos="fade-up" data-aos-duration="1000">
                        <?php echo $wms_main_title; ?>
                        <?php echo $wms_short_description; ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($wms_why_us_details)) : ?>
                    <div class="multifamily-slider" data-aos="fade-up" data-aos-duration="1500">
                        <div class="swiper mySwiper">
                            <div class="swiper-wrapper">
                                <?php foreach ($wms_why_us_details as $why) :
                                    $wms_image = $why['wms_image'];
                                    $wms_title = $why['wms_title'];
                                    $wms_short_description = $why['wms_short_description'];
                                ?>
                                    <?php if ($wms_image || $wms_title || $wms_short_description) : ?>
                                        <div class="swiper-slide">
                                            <div class="multifamily-block">
                                                <div class="multifamily-box">
                                                    <?php if ($wms_image): ?>
                                                        <div class="multifamily-img">
                                                            <figure>
                                                                <img src="<?php echo $wms_image['url']; ?>" alt="<?php echo $wms_image['alt']; ?>">
                                                            </figure>
                                                        </div>
                                                    <?php endif; ?>
                                                    <?php if ($wms_title || $wms_short_description): ?>
                                                        <div class="multifamily-data">
                                                            <?php if ($wms_title): ?>
                                                                <h3><?php echo $wms_title; ?></h3>
                                                            <?php endif; ?>
                                                            <?php echo apply_filters('the_content', $wms_short_description); ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        </div>
                        <?php if (!empty($wms_why_us_details)) : ?>
                            <div class="swiper-nav">
                                <div class="swiper-button-next">
                                    <i class="fal fa-arrow-right"></i>
                                </div>
                                <div class="swiper-button-prev">
                                    <i class="fal fa-arrow-left"></i>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    <?php endif; ?>
    <!-- End Multifamily Section -->

    <!-- Why Commorical Invest -->
    <?php
    $wcis_background_image = get_field('wcis_background_image');
    $wcis_main_title = get_field('wcis_main_title');
    $wcis_description = get_field('wcis_description');
    $wcis_why_us_details = get_field('wcis_why_us_details');
    ?>
    <?php if ($wcis_main_title || $wcis_description || $wcis_why_us_details): ?>
        <section class="why-commorical-invest-wrp">
            <div class="container">
                <?php if ($wcis_main_title || $wcis_description): ?>
                    <div class="why-commorical-invest-head" data-aos="fade-up" data-aos-duration="1000">
                        <div class="row">
                            <?php if ($wcis_main_title): ?>
                                <div class="col-md-8 col-sm-12">
                                    <?php echo $wcis_main_title; ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($wcis_description): ?>
                                <div class="col-md-4 col-sm-12">
                                    <?php echo $wcis_description; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if (!empty($wcis_why_us_details)): ?>
                    <div class="why-choose-list">
                        <ul>
                            <?php
                            $num = 1;
                            $delay_time =  1200;
                            ?>
                            <?php foreach ($wcis_why_us_details as $why): ?>
                                <?php
                                $wcis_icon = $why['wcis_icon'];
                                $wcis_title = $why['wcis_title'];
                                $wis_description = $why['wis_description'];
                                ?>
                                <?php if (($num - 2) % 3 == 0): ?>
                                    <?php if ($wcis_icon || $wcis_title || $wis_description): ?>
                                        <li class="updownbox" data-aos="fade-in" data-aos-duration="<?php echo $delay_time; ?>">
                                            <?php if ($wcis_title || $wis_description): ?>
                                                <div class="why-data-box">
                                                    <?php if ($wcis_title): ?>
                                                        <h3><?php echo $wcis_title; ?></h3>
                                                    <?php endif; ?>
                                                    <?php if ($wis_description): ?>
                                                        <?php echo apply_filters('the_content', $wis_description); ?>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($wcis_icon): ?>
                                                <div class="why-icon-block">
                                                    <figure>
                                                        <img src="<?php echo $wcis_icon['url']; ?>" alt="<?php echo $wcis_icon['alt']; ?>">
                                                    </figure>
                                                </div>
                                            <?php endif; ?>
                                        </li>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php if ($wcis_icon || $wcis_title || $wis_description): ?>
                                        <li data-aos="fade-in" data-aos-duration="<?php echo $delay_time; ?>">
                                            <?php if ($wcis_icon): ?>
                                                <div class="why-icon-block">
                                                    <figure>
                                                        <img src="<?php echo $wcis_icon['url']; ?>" alt="<?php echo $wcis_icon['alt']; ?>">
                                                    </figure>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($wcis_title || $wis_description): ?>
                                                <div class="why-data-box">
                                                    <?php if ($wcis_title): ?>
                                                        <h3><?php echo $wcis_title; ?></h3>
                                                    <?php endif; ?>
                                                    <?php if ($wis_description): ?>
                                                        <?php echo apply_filters('the_content', $wis_description); ?>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                        </li>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php $num++;
                                $delay_time += 300;
                            endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
            <?php if ($wcis_background_image): ?>
                <figure class="why-shop">
                    <img src="<?php echo $wcis_background_image['url']; ?>" alt="<?php echo $wcis_background_image['alt']; ?>">
                </figure>
            <?php endif; ?>
        </section>
    <?php endif; ?>
    <!-- Why Commorical Invest -->

    <!-- Execution Process -->
    <?php
    $ps_main_title = get_field('ps_main_title');
    $ps_description = get_field('ps_description');
    $ps_process_details = get_field('ps_process_details');
    ?>
    <?php if ($ps_process_details): ?>
        <section class="our-process-wrp">
            <div class="container">
                <?php if ($ps_main_title || $ps_description): ?>
                    <div class="titlebar" data-aos="fade-up" data-aos-duration="1000">
                        <?php if ($ps_main_title): ?>
                            <?php echo $ps_main_title; ?>
                        <?php endif; ?>
                        <?php if ($ps_description): ?>
                            <?php echo $ps_description; ?>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>

                <div class="process-row">
                    <ul>
                        <?php
                        $time = 1000;
                        $count = 1;
                        ?>
                        <?php foreach ($ps_process_details as $process_detail): ?>
                            <?php
                            $ps_process_image = $process_detail['ps_process_image'];
                            $ps_process_title = $process_detail['ps_process_title'];
                            $ps_process_description = $process_detail['ps_process_description'];
                            ?>
                            <?php if ($ps_process_image || $ps_process_title || $ps_process_description): ?>
                                <li data-aos="fade-up" data-aos-duration="<?php echo $time; ?>">
                                    <div class="number-bx">
                                        <span><?php echo $count; ?></span>
                                    </div>
                                    <div class="row">
                                        <?php if ($ps_process_image): ?>
                                            <div class="col-md-6 col-sm-12">
                                                <div class="process-img">
                                                    <figure>
                                                        <img src="<?php echo $ps_process_image['url']; ?>" alt="<?php echo $ps_process_image['alt']; ?>">
                                                    </figure>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <?php if ($ps_process_title || $ps_process_description): ?>
                                            <div class="col-md-6 col-sm-12">
                                                <div class="process-data">
                                                    <?php if ($ps_process_title): ?>
                                                        <h3><?php echo $ps_process_title; ?></h3>
                                                    <?php endif; ?>
                                                    <?php if ($ps_process_description): ?>
                                                        <?php echo apply_filters('the_content', $ps_process_description); ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </li>
                            <?php endif; ?>
                        <?php $time += 200;
                            $count++;
                        endforeach; ?>
                    </ul>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- End Execution Process -->

    <!-- We Filtered -->
    <?php
    $fms_main_title = get_field('fms_main_title');
    $fms_description = get_field('fms_description');
    $fms_title = get_field('fms_title');
    $fms_logo_image = get_field('fms_logo_image');
    $fms_why_details = get_field('fms_why_details');
    ?>
    <?php if ($fms_main_title || $fms_description || !empty($fms_why_details)): ?>
        <section class="we-filtered-wrp">
            <div class="container">
                <?php if ($fms_main_title || $fms_description): ?>
                    <div class="filter-head" data-aos="fade-up" data-aos-duration="1000">
                        <div class="row">
                            <?php if ($fms_description): ?>
                                <div class="col-md-6 col-sm-12">
                                    <?php echo $fms_description; ?>
                                </div>
                            <?php endif; ?>
                            <?php if ($fms_main_title): ?>
                                <div class="col-md-6 col-sm-12">
                                    <div class="titlebar">
                                        <?php echo $fms_main_title; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if ($fms_why_details): ?>
                    <div class="filtered-row">
                        <div class="filter-list" id="one" data-aos="fade-up" data-aos-duration="1000">
                            <ul>
                                <?php
                                $count = 1;
                                $total_rows = ceil(count($fms_why_details) / 2);
                                $right_data = '';
                                ?>
                                <?php foreach ($fms_why_details as $fms_why): ?>
                                    <?php $fms_detail = $fms_why['fms_detail']; ?>
                                    <?php if ($fms_detail): ?>
                                        <?php if ($count <= $total_rows): ?>
                                            <li>
                                                <h3>. <?php echo ($count <= 9) ? '0' . $count : $count; ?></h3>
                                                <?php echo apply_filters('the_content', $fms_detail); ?>
                                            </li>
                                        <?php else: ?>
                                            <?php
                                            $right_data .= '<li>';
                                            $right_data .= '<h3>. ' . (($count <= 9) ? '0' . $count : $count) . '</h3>';
                                            $right_data .= apply_filters('the_content', $fms_detail);
                                            $right_data .= '</li>';
                                            ?>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php $count++;
                                endforeach; ?>
                            </ul>
                        </div>
                        <?php if ($fms_title || $fms_logo_image): ?>
                            <div class="filter-center" id="two" data-aos="zoom-in" data-aos-duration="2000">
                                <div class="filter-block">
                                    <?php if ($fms_logo_image): ?>
                                        <figure>
                                            <img src="<?php echo $fms_logo_image['url']; ?>" alt="<?php echo $fms_logo_image['alt']; ?>">
                                        </figure>
                                    <?php endif; ?>
                                    <?php if ($fms_title): ?>
                                        <h2><?php echo $fms_title; ?></h2>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if ($right_data): ?>
                            <div class="filter-list" id="three" data-aos="fade-up" data-aos-duration="1500">
                                <ul>
                                    <?php echo $right_data; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    <?php endif; ?>
    <!-- End We Filtered -->

    <!-- Deal Mechanics & Returns -->
    <?php
    $dmrs_main_title = get_field('dmrs_main_title');
    $dmrs_description = get_field('dmrs_description');
    $dmrs_deal_and_returns_details = get_field('dmrs_deal_and_returns_details');
    ?>
    <?php if ($dmrs_main_title || $dmrs_description || !empty($dmrs_deal_and_returns_details)): ?>
        <section class="deal-mechanic-wrp">
            <div class="container">
                <?php if ($dmrs_main_title || $dmrs_description): ?>
                    <div class="titlebar" data-aos="fade-up" data-aos-duration="1000">
                        <?php if ($dmrs_main_title): ?>
                            <?php echo $dmrs_main_title; ?>
                        <?php endif; ?>
                        <?php if ($dmrs_description): ?>
                            <?php echo $dmrs_description; ?>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php if (!empty($dmrs_deal_and_returns_details)): ?>
                    <div class="row">
                        <?php $delay_time = 1200; ?>
                        <?php foreach ($dmrs_deal_and_returns_details as $deal_return): ?>
                            <?php
                            $dmrs_title = $deal_return['dmrs_title'];
                            $dmrs_icon = $deal_return['dmrs_icon'];
                            $dmrs_detail = $deal_return['dmrs_detail'];
                            ?>
                            <?php if ($dmrs_title || $dmrs_icon || $dmrs_detail): ?>
                                <div class="col-md-3 col-sm-6">
                                    <div class="deal-box" data-aos="fade-up" data-aos-duration="<?php echo $delay_time; ?>">
                                        <?php if ($dmrs_title): ?>
                                            <h3><?php echo $dmrs_title; ?></h3>
                                        <?php endif; ?>
                                        <?php if ($dmrs_detail): ?>
                                            <?php echo apply_filters('the_content', $dmrs_detail); ?>
                                        <?php endif; ?>
                                        <?php if ($dmrs_icon): ?>
                                            <figure>
                                                <img src="<?php echo $dmrs_icon['url']; ?>" alt="<?php echo $dmrs_icon['alt']; ?>">
                                            </figure>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php $delay_time += 300;
                        endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </section>
    <?php endif; ?>
    <!-- End Deal Mechanics & Returns -->

    <!-- Professional Section -->
    <?php
    $ops_main_title = get_field('ops_main_title');
    $ops_description = get_field('ops_description');
    $args = array(
        'post_type'      => 'expert',
        'post_status'    => 'publish',
        'posts_per_page' => -1,
        'orderby'        => 'date',
        'order'          => 'DESC'
    );

    $experts = new WP_Query($args);
    ?>
    <?php if ($experts->have_posts()): ?>
        <section class="professional-wrp">
            <div class="container">
                <?php if ($ops_main_title || $ops_description): ?>
                    <div class="professional-head" data-aos="fade-up" data-aos-duration="1000">
                        <div class="row">
                            <?php if ($ops_main_title): ?>
                                <div class="col-md-7 col-sm-12">
                                    <div class="titlebar">
                                        <?php echo $ops_main_title; ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <?php if ($ops_description): ?>
                                <div class="col-md-5 col-sm-12">
                                    <?php echo $ops_description; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <?php while ($experts->have_posts()) : $experts->the_post(); ?>
                    <?php
                    $title = get_the_title();
                    $content = get_the_content();
                    $img = get_the_post_thumbnail_url();
                    ?>
                    <?php if ($title || $content || $img): ?>
                        <div class="professional-row" data-aos="fade-up" data-aos-duration="1500">
                            <div class="row">
                                <?php if ($title || $content): ?>
                                    <div class="col-md-7 col-sm-12">
                                        <div class="professional-data">
                                            <?php if ($title): ?>
                                                <h3><?php echo $title; ?></h3>
                                            <?php endif; ?>
                                            <?php if ($content): ?>
                                                <?php echo apply_filters('the_content', $content); ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <?php if ($img): ?>
                                    <div class="col-md-5 col-sm-12">
                                        <div class="professional-img">
                                            <figure>
                                                <img src="<?php echo $img; ?>" alt="<?php $title; ?>">
                                            </figure>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </section>
    <?php endif; ?>
    <!-- End Professional Section -->

    <!-- Contact Section -->
    <?php get_template_part('template-parts/content', 'map'); ?>
    <!-- End Contact Section -->
<?php
endwhile;
get_footer();
?>